/*
 * EKF.h
 *
 *  Created on: Apr 7, 2015
 *      Author: Jordan
 */

#ifndef USER_CODE_EKF_H_
#define USER_CODE_EKF_H_

#define FS 50

#define AHRS_N_STATES 7
#define AHRS_N_INPUTS 3
#define AHRS_N_MEAS 6
#define Q_VAR 0.001
#define BW_VAR 0.0001
#define A_VAR 0.03
#define M_VAR 0.1

#define INS_N_STATES 9
#define INS_N_INPUTS 3
#define INS_N_MEAS 5
#define P_VAR 0.001
#define V_VAR 0.2
#define VZ_VAR 0.001
#define P_GPS_VAR 2
#define V_GPS_VAR 0.1
#define P_ALT_VAR 0.1
#define BA_VAR 0.0001

#define EARTH_BX 0.5156
#define EARTH_BY -0.0509
#define EARTH_BZ 0.8553
#define GRAVITY 9.81

void update_AHRS_u(float wx, float wy, float wz);
void update_AHRS_z(float ax, float ay, float az, float mx, float my, float mz);
void init_AHRS(float qs, float qx, float qy, float qz, float bwx, float bwy, float bwz);
void AHRS_calc_f();
void AHRS_calc_F();
void AHRS_calc_h();
void AHRS_calc_H();
void AHRS_init_matrices();
void AHRS_step();
void AHRS_normalize_q();

void update_INS_u(float ax, float ay, float az);
void update_INS_z(float px, float py, float pz, float vx, float vy);
void init_INS(float px, float py, float pz, float vx, float vy, float vz, float bax, float bay, float baz);
void INS_calc_f();
void INS_calc_F();
void INS_calc_h();
void INS_calc_H();
void INS_init_matrices();
void INS_step();
void INS_normalize_q();

#endif /* USER_CODE_EKF_H_ */
